/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.markers.MarkerViewUtil;

import com.curl.eclipse.remote.MediatorConnection;
import com.curl.eclipse.util.CoreUtil;
import com.curl.eclipse.util.CurlUIIDs;

public class ManageProblems
{
    public static void addProblem(
            String url,
            int line,
            int column,
            int severity,
            String message)
    {
        // TODO:  What if the file is not in the workspace?  We are ignoring those files!
        IFile resource = CoreUtil.getFile(url);
        if (resource != null) {
            try {
                final IMarker marker = resource.createMarker(CurlUIIDs.ID_CURL_PROBLEM_MARKER);
                int markerSeverity;
                if (severity == MediatorConnection.commandReportSyntaxErrorSeverityError)
                    markerSeverity = IMarker.SEVERITY_ERROR;
                else if (severity == MediatorConnection.commandReportSyntaxErrorSeverityWarning)
                    markerSeverity = IMarker.SEVERITY_WARNING;
                else
                    markerSeverity = IMarker.SEVERITY_INFO;
                marker.setAttribute(IMarker.LINE_NUMBER, line);
                marker.setAttribute(CurlUIIDs.COLUMN_NUMBER_ATTRIBUTE_NAME_MARKER, column);
                marker.setAttributes(
                        new String[] {IMarker.MESSAGE, IMarker.SEVERITY},
                        new Object[] {message, new Integer(markerSeverity)});
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable() {
                    public void run()
                    {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(); 
                        if (page != null) {
                            MarkerViewUtil.showMarker(page, marker, true);
                        }
                    }
                });
            } catch (Exception e) {
                CoreUtil.logError("Curl problem marker could not be created.", e); //$NON-NLS-1$
            }
        } else {
            CoreUtil.logError("ManageProblems.addProblem: Couldn't get workbench resource for url " + url); //$NON-NLS-1$
        }
    }

    public static void clearProblems()
    {
        try {
            IMarker[] curlProblemMarkers = ResourcesPlugin.getWorkspace().getRoot().findMarkers(CurlUIIDs.ID_CURL_PROBLEM_MARKER, true, IResource.DEPTH_INFINITE);
            ResourcesPlugin.getWorkspace().deleteMarkers(curlProblemMarkers);
        } catch (CoreException e) {
            CoreUtil.logError("Curl problem markers could not be cleared", e); //$NON-NLS-1$
        }
    }
}
