/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.debug.core.DebugException;

/**
 * The result of an expression evaluation. An evaluation result may
 * contain problems and/or a result value.
 */

public interface IEvaluationResult {
        
        /**
         * Returns the value representing the result of the
         * evaluation, or null if the associated evaluation failed. If
         * the associated evaluation failed, there will
         * be problems, or an exception in this result.
         */
        public CurlValue getValue();
        
        /**
         * Returns whether the evaluation had any problems
         * or if an exception occurred while performing the
         * evaluation.
         */
        public boolean hasErrors();
        
        /**
         * Returns an array of problem messages. Each message describes a problem that
         * occurred while compiling the snippet.
         */
        public String[] getErrorMessages();
                
        /**
         * Returns any exception that occurred while performing the evaluation
         * or nullif an exception did not occur.
         */
        public DebugException getException();
        
        /**
         * Returns the snippet that was evaluated.
         */
        public String getSnippet();        
}
