/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;


/**
 * A variable in a Curl stack frame
 */
public class CurlVariable extends CurlDebugElement implements IVariable
{
    private final CurlVariableDescriptor fCurlVarDesc;
    private CurlValue fCurlValue;
    
    private boolean fHasChanged;
    private final String fParentPath;
    private final String fFullPath;

    /**
     * @param target
     * @param curlVariableDesc
     * @param curlStackFrame 
     * @param parentPath 
     */
    public CurlVariable(
            CurlDebugTarget target,
            CurlVariableDescriptor curlVariableDesc, 
            String parentPath)
    {
        super(target, curlVariableDesc.fName);
        fCurlVarDesc = curlVariableDesc;
        fParentPath = parentPath;
        fFullPath = fParentPath + '.' + fCurlVarDesc.fName;
    }

    public IValue getValue() throws DebugException
    {
        if (fCurlValue == null) {
            
            fCurlValue = new CurlValue(
                    getDebugTarget(), 
                    new CurlValueDescriptor(
                            fCurlVarDesc.fTypeName, 
                            fCurlVarDesc.fValue, 
                            fCurlVarDesc.fVariableID,
                            fCurlVarDesc.fExpandable),
                            fFullPath);

            CurlValue previousValue = getDebugTarget().getPreviouslyRecordedVariableValue(fFullPath);
            if (previousValue != null && ! equalsValue(previousValue, fCurlValue)) {
                fHasChanged = true;
            }
            getDebugTarget().recordVariableValue(fFullPath, fCurlValue);
        }
        return fCurlValue;
    }

    String getFullPath()
    {
        return fFullPath;
    }

    private boolean equalsValue(
            CurlValue v1,
            CurlValue v2)
    {
        String s1 = v1.getValueString();
        String s2 = v2.getValueString();
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public String getName() throws DebugException
    {
        return fCurlVarDesc.fName;
    }

    public String getReferenceTypeName() throws DebugException
    {
        // We don't have a declared type, we only have the actual type.
        return ""; //$NON-NLS-1$
    }

    
    /**
     * @see IVariable#hasValueChanged()
     */
    @Override
    public boolean hasValueChanged() {
        return fHasChanged;
    }

    public void setValue(
            String expression) throws DebugException
    {
        // TODO
    }

    public void setValue(
            IValue value) throws DebugException
    {
        // TODO
    }

    public boolean supportsValueModification()
    {
        // TODO
        return false;
    }

    public boolean verifyValue(
            String expression) throws DebugException
    {
        // TODO
        return false;
    }

    public boolean verifyValue(
            IValue value) throws DebugException
    {
        // TODO
        return false;
    }

    public String getActualTypeName()
    {
        return fCurlVarDesc.fTypeName;
    }
}
