/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;

import com.curl.eclipse.util.CoreUtil;

/**
 * The value of a Curl variable
 */
public class CurlValue extends CurlDebugElement implements IValue
{
    private final IVariable[] EMPTY = new IVariable[0]; 
    private boolean fVarsReceived = false;
    private final CurlValueDescriptor fCurlValueDesc;
    private IVariable[] fVariables;
    private final String fVariablePath;

    public CurlValue(
            CurlDebugTarget target,
            CurlValueDescriptor curlValueDesc, 
            String variablePath)
    {
        super(target, null);
        fCurlValueDesc = curlValueDesc;
        fVariablePath = variablePath;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getAdapter(
            Class adapter)
    {
        if (adapter == CurlValue.class) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public String getValueString()
    {
        return fCurlValueDesc.fValue;
    }

    public String getReferenceTypeName()
    {
        return fCurlValueDesc.fValueType;
    }

    @Override
    public int hashCode()
    {
        //TODO:  Do we need to implement this?
        CoreUtil.logWarning("hashCode is NYI for CurlValue"); //$NON-NLS-1$
        return 1;
    }

    @Override
    public boolean equals(
            Object o)
    {
        //TODO:  Do we need to implement this?
        CoreUtil.logWarning("equals is NYI for CurlValue"); //$NON-NLS-1$
        return false;
    }

    public IVariable[] getVariables() throws DebugException
    {
        if (fVarsReceived) {
            return fVariables;
        }
        if (hasVariables()) {
            CurlVariableDescriptor[] varDescs = getDebugTarget().getProcess().getProxy().expandVars(fCurlValueDesc.fValueID);
            fVariables = new CurlVariable[varDescs.length];
            for (int i = 0; i < varDescs.length; i++) {
                fVariables[i] = new CurlVariable(getDebugTarget(), varDescs[i], fVariablePath);
            }
            fVarsReceived = true;
            return fVariables;
        }
        return EMPTY;
    }

    public boolean isAllocated() throws DebugException
    {
        // TODO:  Can it ever be false?
        return true;
    }

    @Override
    public String toString()
    {
        return fCurlValueDesc.fValue;
    }

    public boolean hasVariables() throws DebugException
    {
        return fCurlValueDesc.fHasVariables;
    }
}
