/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;


public class CurlStackFrameDescriptor
{
    final private int fFrameNumber;
    // We have to keep the "reason" in stack frame (as opposed to in the breakpoint descriptor
    // because we may not have a breakpoint!  We could have an uncaught exception.
    final private int fReason;
    final private String fExceptionBreakpointTypeName;
    final private String fExceptionBreakpointReason;
    final private String fFunctionName;
    final private boolean fHasDebugInfo; // if false, fFileName and fLineNumber are empty strings
    final private boolean fIsMissingFrame;
    final private String fMissingFrameDescription;
    private String fFileName;
    final private int fLineNumber;
    
    private CurlStackFrameDescriptor(
            int frameNumber,
            int reason,
            String exceptionBreakpointTypeName,
            String exceptionBreakpointReason,
            String functionName,
            boolean hasDebugInfo,
            boolean isMissingFrame,
            String missingFrameDescription,
            String fileName,
            int lineNumber)
    {
        fFrameNumber = frameNumber;
        fReason = reason;
        fExceptionBreakpointTypeName = exceptionBreakpointTypeName;
        fExceptionBreakpointReason = exceptionBreakpointReason;
        fFunctionName = functionName;
        fHasDebugInfo = hasDebugInfo;
        fIsMissingFrame = isMissingFrame;
        fMissingFrameDescription = missingFrameDescription;
        fLineNumber = lineNumber;        
        fFileName = ""; //$NON-NLS-1$
        if (hasDebugInfo) {
            // FIXME: what about curl://string etc....
            // we probably want to trim...
            fFileName = fileName;
//            try {
//                fFileName = new URL(fileName).toString();
//            } catch (MalformedURLException e) {
//                fFileName = "";
//                CoreUtil.logWarning("Malformed URL in stack frame");
//            }
        }
    }

    public static CurlStackFrameDescriptor makeFullFrameDesc(
            int frameNumber,
            int reason,
            String exceptionBreakpointTypeName,
            String exceptionBreakpointReason,
            String functionName,
            boolean hasDebugInfo,
            String fileName,
            int lineNumber)
    {
        return new CurlStackFrameDescriptor(
                frameNumber,
                reason,
                exceptionBreakpointTypeName,
                exceptionBreakpointReason,
                functionName,
                hasDebugInfo,
                false,
                "", //$NON-NLS-1$
                fileName,
                lineNumber);
    }

    public static CurlStackFrameDescriptor makeMissingFrameDesc(
            int frameNumber,
            int reason,
            String missingFrameDescription)
    {
        return new CurlStackFrameDescriptor(
                frameNumber,
                reason,
                "", //$NON-NLS-1$
                "", //$NON-NLS-1$
                "", //$NON-NLS-1$
                false,
                true,
                missingFrameDescription,
                "", //$NON-NLS-1$
                0);
    }

    public int getFrameNumber()
    {
        return fFrameNumber;
    }

    public int getReason()
    {
        return fReason;
    }

    public String getExceptionBreakpointTypeName()
    {
        return fExceptionBreakpointTypeName;
    }

    public String getExceptionBreakpointReason()
    {
        return fExceptionBreakpointReason;
    }

    public String getFunctionName()
    {
        if (isMissingFrame())
            return DebugMessages.DebugModelPresentationMissingFunctionName;
        else
            return fFunctionName;
    }

    public boolean hasDebugInfo()
    {
        return fHasDebugInfo;
    }

    public boolean isMissingFrame()
    {
        return fIsMissingFrame;
    }

    public String getFileName()
    {
        return fFileName;
    }

    public int getLineNumber()
    {
        return fLineNumber;
    }

    public String getMissingFrameDescription()
    {
        return fMissingFrameDescription;
    }
}
