/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourcePathComputerDelegate;
import org.eclipse.debug.core.sourcelookup.containers.FolderSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ProjectSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.WorkspaceSourceContainer;
import com.curl.eclipse.util.CurlUIIDs;

/**
 * Computes the default source lookup path for a Curl launch configuration.
 * The default source lookup path is the folder or project containing 
 * the Curl program being launched. If the program is not specified, the workspace
 * is searched by default.
 */
public class CurlSourcePathComputerDelegate implements ISourcePathComputerDelegate
{
    public ISourceContainer[] computeSourceContainers(
            ILaunchConfiguration configuration,
            IProgressMonitor monitor) throws CoreException
    {
        String path = configuration.getAttribute(CurlUIIDs.ATTR_APPLET_FILE_FULL_PATH, (String)null);
        ISourceContainer sourceContainer = null;
        if (path != null) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(new Path(path));
            // TODO:  This does not handle external files, or buffer file!!!  Perhaps we should simply
            // compure a source container from the URL's path given to us from the mediator.
            if (resource != null) {
                IContainer container = resource.getParent();
                if (container.getType() == IResource.PROJECT) {
                    sourceContainer = new ProjectSourceContainer((IProject)container, false);
                } else if (container.getType() == IResource.FOLDER) {
                    sourceContainer = new FolderSourceContainer(container, false);
                }
            }
        }
        if (sourceContainer == null) {
            sourceContainer = new WorkspaceSourceContainer();
        }
        return new ISourceContainer[] { sourceContainer };
    }
}
