/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import java.net.URI;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;

import com.curl.eclipse.util.CoreUtil;

/**
 * This is the source code lookup support for Curl.  In curl, the
 * debug information has a full path to the running source code, since
 * the code is JIT compiled.  So all we need to is return a full path
 * for the source name, and convert the path to an IFile using
 * CoreUtil.getFile().
 */
public class CurlSourceLookupDirector extends AbstractSourceLookupDirector
{
    private class CurlSourceContainer extends AbstractSourceContainer
    {
        @Override
        public Object[] findSourceElements(
                String name) throws CoreException
        {
            Object element = CoreUtil.getFile(name);
            if (element == null) {
                element = EFS.getStore(URI.create(name));
//                File file = new File(URI.create(name));
//                if (fileStore.exists()) {
//                    element = new LocalFileStorage(file);
//                }
//                else {
//                    // TODO: I suppose that that's where we'd need to support
//                    // "curl://" URLs
//                    CoreUtil.logWarning("Could not locate source for:" + name);
//                }
            }
            if (element != null) {
                return new Object[] { element };
            } else {
                return new Object[] { };
            }
        }

        @Override
        public String getName()
        {
            return DebugMessages.CurlSourceLookupDirector_0;
        }

        @Override
        public ISourceContainerType getType()
        {
            // FIXME: Not sure what we should return, but null will
            // generate NPE in some use case like clicking on the
            // "Edit Source Lookup Path..." button when debugging
            // and when the source file can't be located.
            return null;
        }
    }

    @Override
    public synchronized ISourceContainer[] getSourceContainers()
    {
        return new ISourceContainer[] { new CurlSourceContainer() };
    }

    /**
     * The Curl source lookup participant translates a Curl stack frame into a
     * source file name.
     */
    private class CurlSourceLookupParticipant extends AbstractSourceLookupParticipant
    {
        public String getSourceName(
                Object object) throws CoreException
        {
            if (object instanceof CurlStackFrame) {
                CurlStackFrame sf = (CurlStackFrame)object;
                return sf.getSourceName();
            }
            return null;
        }
    }

    public void initializeParticipants()
    {
        addParticipants(new ISourceLookupParticipant[] { new CurlSourceLookupParticipant() });
    }
}
