/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

import com.curl.eclipse.remote.DebugProxyData;

/**
 * Implements an Eclipse process.  See IProcess for details.  It does what RuntimeProcess does in 
 * the standard debug model.  
 * 
 * It represents a Curl applet as an "Eclipse process" in the Eclipse debug model.
 * 
 * This class communicates with the Curl applet through the proxy to keep
 * the state of a running Eclipse process (start, terminate, suspend, resume, etc.) in synch
 * with its corresponding Curl applet.
 */
public class CurlProcess extends CurlDebugElement implements IProcess
{
    private DebugProxyData fDebugProxyData;
    private int fExitValue;
    private boolean fTerminated;
    private boolean fSuspended;
    private boolean fCanResume;
    private boolean fCanSuspend;
    private boolean fCanTerminate;
    
    public CurlProcess(CurlDebugTarget target, String name)
    {
        super(target, name);
        fTerminated = false;
        fCanResume = false;
        fCanSuspend = true;
        fCanTerminate = false;
    }
    
    public int getExitValue() throws DebugException
    {
        return fExitValue;
    }

    public String getLabel()
    {
        return fName;
    }

    public IStreamsProxy getStreamsProxy()
    {
        // TODO
        return null;
    }

    public boolean canResume()
    {
        return fCanResume;
    }

    public boolean canSuspend()
    {
        return fCanSuspend;
    }

    public boolean canTerminate()
    {
        return fCanTerminate;
    }

    public boolean isTerminated()
    {
        return fTerminated;
    }
        
    public void setStateEnablement(
            boolean canResume,
            boolean canSuspend,
            boolean canTerminate)
    {
        fCanResume = canResume;
        fCanSuspend = canSuspend;
        fCanTerminate = canTerminate;
    }

    public boolean isSuspended()
    {
        return fSuspended;
    }

    public void noteResumedState()
    {
        fSuspended = false;
        // FIXME:  We need to get the following states from the mediator!  
        fCanResume = false;
        fCanSuspend = true;
        fCanTerminate = false;
    }

    public void noteTerminatedState()
    {
        fSuspended = false;
        fTerminated = true;
        fCanResume = false;
        fCanSuspend = false;
        fCanTerminate = false;
    }

    public void noteSuspendedState(
            boolean canResume,
            boolean canSuspend,
            boolean canTerminate)
    {
        fCanResume = canResume;
        fCanSuspend = canSuspend;
        fCanTerminate = canTerminate;
        fSuspended = true;
    }

    /*
     * Proxy communication methods
     */ 

    public DebugProxyData getProxy()
    {
        return fDebugProxyData;
    }

    public void setProxy(
            DebugProxyData proxy)
    {
        fDebugProxyData = proxy;
    }

    public void terminate() throws DebugException
    {
        fDebugProxyData.terminate();
    }

    public void disconnect()
    {
        //TODO
    }

    public boolean canDisconnect()
    {
        //TODO
        return false;
    }

    public boolean isDisconnected()
    {
        //TODO
        return false;
    }

    @SuppressWarnings("unchecked")
    @Override
    public Object getAdapter(
            Class adapter)
    {
        if (adapter.equals(IProcess.class)) {
            return this;
        }
        if (adapter.equals(IDebugTarget.class)) {
            getDebugTarget();
        }
        if (adapter.equals(ILaunch.class)) {
            return getLaunch();
        }
        return super.getAdapter(adapter);
    }
}
