/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import java.net.URI;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.model.IBreakpoint;

import com.curl.eclipse.util.CurlUIIDs;

/**
 * Describes a Curl line breakpoint
 */
public class CurlLineBreakpointDescriptor extends CurlBreakpointDescriptor
{
    public final int fLineNumber;
    public final String fCondition;
    
    /** null if dealing with a resource in the workspace */
    public final String fNonWorkspaceResourceName;

    public CurlLineBreakpointDescriptor(
            boolean enabled,
            IResource resource,
            String fileName, 
            int lineNumber,
            String condition)
    {
        fEnabled = enabled;
        fResource = resource;
        fNonWorkspaceResourceName = fileName;
        fLineNumber = lineNumber;
        fCondition = condition;
    }

    public CurlLineBreakpointDescriptor(
            IMarker marker)
    {
        fNonWorkspaceResourceName = marker.getAttribute(CurlUIIDs.ATTR_DEBUG_NON_WORKSPACE_RESOURCE_NAME, null);
        fEnabled = marker.getAttribute(IBreakpoint.ENABLED, false);
        fLineNumber = marker.getAttribute(IMarker.LINE_NUMBER, 0);
//        fResource = CoreUtil.getFile(marker.getAttribute(CurlUIIDs.ATTR_DEBUG_FILE_NAME, ""));
        fResource = marker.getResource();
        fCondition = marker.getAttribute(CurlUIIDs.ATTR_DEBUG_CONDITION, ""); //$NON-NLS-1$
    }

    public URI getLocationURI()
    {
        if (fNonWorkspaceResourceName != null) {
            return URI.create(fNonWorkspaceResourceName);
        }
        return fResource.getLocationURI();
    }
}
