/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jface.text.source.Annotation;

/**
 *
 */
public class CurlInstructionPointerAnnotation extends Annotation
{

    private IStackFrame fFrame;

    public CurlInstructionPointerAnnotation(
            IStackFrame frame)
    {
        super(false);
        fFrame = frame;
    }

    public IStackFrame getFrame()
    {
        return fFrame;
    }
    
    public boolean equals(
            Object obj)
    {
        if (obj instanceof CurlInstructionPointerAnnotation) {
            CurlInstructionPointerAnnotation that = (CurlInstructionPointerAnnotation)obj;
                return 
                    that.fFrame.equals(fFrame);
        }
        return false;
    }

    public int hashCode()
    {
        return fFrame.hashCode();
    }
}
