/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import com.curl.eclipse.util.CurlUIIDs;

public class CurlExceptionBreakpointDescriptor extends CurlBreakpointDescriptor
{
    public String fExceptionTypeName;
    public CurlExceptionBreakpointDescriptor(
            boolean enabled,
            String exceptionTypeName)
    {
        fEnabled = enabled;
        fExceptionTypeName = exceptionTypeName;
        fResource = ResourcesPlugin.getWorkspace().getRoot();
    }

    public CurlExceptionBreakpointDescriptor(
            IMarker marker)
    {
        fEnabled = marker.getAttribute(IBreakpoint.ENABLED, false);
        fExceptionTypeName = marker.getAttribute(CurlUIIDs.ATTR_EXCEPTION_TYPE_NAME, ""); //$NON-NLS-1$
        fResource = ResourcesPlugin.getWorkspace().getRoot();
    }
}
