/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.model.IBreakpoint;

import com.curl.eclipse.util.CoreUtil;
import com.curl.eclipse.util.CurlUIIDs;

public class CurlExceptionBreakpoint extends CurlBreakpoint
{
    /**
     * Default constructor is required for the breakpoint manager
     * to re-create persisted breakpoints. After instantiating a breakpoint,
     * the setMarker(...) method is called to restore this breakpoint's attributes.
     */
    public CurlExceptionBreakpoint()
    {
    }

    public CurlExceptionBreakpoint(
            final CurlExceptionBreakpointDescriptor bpeDesc)
    {
        try {
            IMarker marker = bpeDesc.fResource.createMarker(CurlUIIDs.ID_CURL_EXCEPTION_DEBUG_MARKER);
            setMarker(marker);
            marker.setAttribute(IBreakpoint.ENABLED, bpeDesc.fEnabled);
            marker.setAttribute(CurlUIIDs.ATTR_EXCEPTION_TYPE_NAME, bpeDesc.fExceptionTypeName);
            marker.setAttribute(IBreakpoint.ID, getModelIdentifier());
            marker.setAttribute(
                    IMarker.MESSAGE, 
                    DebugMessages.CurlExceptionBreakpoint_0 + bpeDesc.fExceptionTypeName);
            // TODO: Why is the breakpoint not persisted?
        } catch (Exception e) {
            CoreUtil.logError("Curl exception breakpoint could not be created.", e); //$NON-NLS-1$
        }
    }
    
    /**
     * Name of the exception that identifies this breakpoint
     */
    public String getExceptionTypeName()
    {
        return getMarker().getAttribute(CurlUIIDs.ATTR_EXCEPTION_TYPE_NAME, ""); //$NON-NLS-1$
    }

    public boolean match(
            String exceptionTypeName)
    {
        return getExceptionTypeName().equals(exceptionTypeName);
    }

    @Override
    public CurlBreakpointDescriptor makeDescriptor()
    {
        return new CurlExceptionBreakpointDescriptor(getMarker());        
    }
}
