/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

public class CurlEvaluationDescriptor
{
    public final boolean fHasErrors;
    public final String fErrorMessage;
    public final String fExpressionText;
    public final CurlVariableDescriptor fVarDesc;
    
    private CurlEvaluationDescriptor(
            String expressionText,
            boolean hasErrors,
            String errorMessage,
            CurlVariableDescriptor varDesc)
    {
        fExpressionText = expressionText;
        fHasErrors = hasErrors;
        fErrorMessage = errorMessage;
        fVarDesc = varDesc;
    }

    public CurlEvaluationDescriptor(
            String evaluationText,
            String errorMessage)
    {
        this(evaluationText, true, errorMessage, null);
    }

    public CurlEvaluationDescriptor(
            String evaluationText,
            CurlVariableDescriptor curlVariableDescriptor)
    {
        this(evaluationText, false, "", curlVariableDescriptor); //$NON-NLS-1$
    }
}
