/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.model.DebugElement;
import org.eclipse.debug.core.model.IDebugElement;

import com.curl.eclipse.util.CurlUIIDs;

/**
 * Common function of Curl debug model elements
 */
public abstract class CurlDebugElement extends DebugElement implements IAdaptable, IDebugElement
{
    protected String fName;
    protected Map<String, String> fAttributes;

    public CurlDebugElement(
            CurlDebugTarget target,
            String name)
    {
        super(target);
        fName = name;
    }

    public String getModelIdentifier()
    {
        return CurlUIIDs.ID_CURL_DEBUG_MODEL;
    }

    public String getAttribute(
            String key)
    {
        if (fAttributes == null) {
            return null;
        }
        return fAttributes.get(key);
    }

    public void setAttribute(
            String key,
            String value)
    {
        if (fAttributes == null) {
                fAttributes = new HashMap<String, String>(5);
        }
        Object origVal = fAttributes.get(key);
        if (origVal != null && origVal.equals(value)) {
                return; //nothing changed.
        }
        
        fAttributes.put(key, value);
        fireEvent(new DebugEvent(this, DebugEvent.CHANGE));
    }
    
    @Override
    public CurlDebugTarget getDebugTarget()
    {
        return (CurlDebugTarget)super.getDebugTarget();
    }    
}
