/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.debug;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.Breakpoint;

import com.curl.eclipse.util.CurlUIIDs;

public abstract class CurlBreakpoint extends Breakpoint
{
    public String getModelIdentifier()
    {
        return CurlUIIDs.ID_CURL_DEBUG_MODEL;
    }

    public int getLineNumber() throws CoreException
    {
        IMarker m = getMarker();
        if (m != null) {
            return m.getAttribute(IMarker.LINE_NUMBER, -1);
        }
        return -1;
    }    

    public abstract CurlBreakpointDescriptor makeDescriptor();
}
