/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.core;


import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;

/**
 * A curl element as defined in the curl language.
 * When CPA is available this class should map on top of elements provided by CPA.
 * 
 * @author fmisiak
 * TODO: refactor to have a parent CurlElement
 */
public class CurlElement implements IAdaptable
{
    private final IFile fFile;
    private final SearchForEnum fType;
    private final String fNameOfType;
    private final String fSymbolName;
    private final int fRow;
    private final int fCol;
    private final int fParentRow;
    private final int fParentCol;
    private final BindingInfo info;
    private final BindingInfo infoParent;
    private final SearchForEnum fParentType;
    
    public CurlElement(
            IFile file,
            SearchForEnum type,
            String nameOfType, 
            String symbolName, 
            int row,
            int col, 
            BindingInfo bindingInfo)
    {
        this(file, type, nameOfType, symbolName, row, col, -1, -1, bindingInfo, null, null);
    }
    
    public CurlElement(
            IFile file,
            SearchForEnum type,
            String nameOfType, 
            String symbolName, 
            int row,
            int col, 
            int parentRow,
            int parentCol, 
            BindingInfo info, 
            BindingInfo infoParent, 
            SearchForEnum parentType)
    {
        this.fFile = file;
        this.fType = type;
        this.fNameOfType = nameOfType;
        this.fSymbolName = symbolName;
        this.fRow = row;
        this.fCol = col;
        this.fParentRow = parentRow;
        this.fParentCol = parentCol;
        this.info = info;
        this.infoParent = infoParent;
        this.fParentType = parentType;
    }

    public IFile getFile()
    {
        return fFile;
    }

    public SearchForEnum getType()
    {
        return fType;
    }

    public String getNameOfType()
    {
        return fNameOfType;
    }
    
    @Override
    public String toString()
    {
        if (fType == null) {
            return fFile.toString();
        }
        switch (fType) {
        case classCurl:
        case enumCurl:
            return fNameOfType;
        default:
            return fSymbolName;
        }
    }
    
    @Override
    public boolean equals(
            Object obj)
    {
        if (obj instanceof CurlElement) {
            CurlElement that = (CurlElement)obj;
            return that.fFile.equals(fFile) 
                    && that.fNameOfType.equals(fNameOfType)
                    && equals(that.fSymbolName, fSymbolName)
                    && equals(that.fType, fType)
                    && that.fRow == fRow
                    && that.fCol == fCol
                    && that.fParentRow == fParentRow
                    && that.fParentCol == fParentCol;
        }
        return super.equals(obj);
    }
    
    private boolean equals(
            String o1,
            String o2)
    {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    static boolean equals(SearchForEnum o1, SearchForEnum o2)
    {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }
    
    @Override
    public int hashCode()
    {
        return fFile.hashCode() << 4 
            +(fSymbolName == null ? 0 : fSymbolName.hashCode()) << 2 
            +  fNameOfType.hashCode() << 1 
            + hashCode(fType)
            + fRow + fCol
            + fParentCol + fParentRow;
    }

    private int hashCode(
            SearchForEnum type)
    {
        return type == null ? 0 : type.hashCode();
    }

    public String getSymbolName()
    {
        return fSymbolName;
    }

    @SuppressWarnings("unchecked") 
    @Override
    public Object getAdapter(
            Class adapter)
    {
        // FIXME
        return null;
    }

    public int getRow()
    {
        return fRow;
    }

    public int getCol()
    {
        return fCol;
    }

    public int getParentRow()
    {
        return fParentRow;
    }

    public int getParentCol()
    {
        return fParentCol;
    }
    
    public BindingInfo getInfo()
    {
        return info;
    }
    
    public BindingInfo getInfoParent()
    {
        return infoParent;
    }

    public boolean isData()
    {
        return fType.isData();
    }

    public SearchForEnum getParentType()
    {
        return fParentType;
    }

}
