/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
/**
 * 
 */
package com.curl.eclipse.core;

public class BindingInfo
{
    private static final int attribute_mask_abstract = 0x00000001;
    private static final int attribute_mask_constant = 0x00000002;
//    private static final int attribute_mask_data = 0x00000004;
    private static final int attribute_mask_deprecated = 0x00000008;
    private static final int attribute_mask_external = 0x00000010;
    private static final int attribute_mask_final = 0x00000020;
    private static final int attribute_mask_implicit = 0x00000040;
    private static final int attribute_mask_inline = 0x00000080;
    private static final int attribute_mask_sealed = 0x00000100;
    private static final int attribute_mask_transient = 0x00000200;
    private static final int attribute_mask_weak = 0x00000400;

    public int attributes;
    public AccessEnum access;
    public AccessEnum writeAccess;
    
    public boolean isAbstract()
    {
        return (attributes & attribute_mask_abstract) != 0;
    }
    
    public boolean isConstant()
    {
        return (attributes & attribute_mask_constant) != 0;
    }
    
//    public boolean isData()
//    {
//        return (attributes & attribute_mask_data) != 0;
//    }
    
    public boolean isDeprecated()
    {
        return (attributes & attribute_mask_deprecated) != 0;
    }
    
    public boolean isExternal()
    {
        return (attributes & attribute_mask_external) != 0;
    }
    
    public boolean isFinal()
    {
        return (attributes & attribute_mask_final) != 0;
    }
    
    public boolean isImplicit()
    {
        return (attributes & attribute_mask_implicit) != 0;
    }
    
    public boolean isInline()
    {
        return (attributes & attribute_mask_inline) != 0;
    }
    
    public boolean isSealed()
    {
        return (attributes & attribute_mask_sealed) != 0;
    }
    
    public boolean isTransient()
    {
        return (attributes & attribute_mask_transient) != 0;
    }
    
    public boolean isWeak()
    {
        return (attributes & attribute_mask_weak) != 0;
    }
    
}