/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.core;

import java.util.HashMap;

/**
 * Note that each int value associated with an access
 * is defined in Curl (see Curl doc for class BindingAccess)
 * Note the order of the declaration, it indicates
 * the higher in the list the higher the scope.
 * <blockquote>
 *  public > hidden > protected > package > private
 * </blockquote>
 */
public enum AccessEnum
{
    accessPublic(9),
    accessHidden(7),
    accessProtected(5),
    accessPackage(3),
    accessPrivate(1);

    private static  HashMap<Integer, AccessEnum> mapValueToAccessEnum = new HashMap<Integer, AccessEnum>();
    
    static {
        for(AccessEnum v : AccessEnum.values()) {
            mapValueToAccessEnum.put(v.fValue, v);
        }
    }
    
    public static AccessEnum fromValue(int value)
    {
        AccessEnum res = mapValueToAccessEnum.get(value);
        return res;
    }

    private final int fValue;
    
    AccessEnum(int value) {
        fValue = value;
    }
    
}