/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.console;

import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.remote.ConsoleProxyData;
import com.curl.eclipse.util.CoreUtil;
import com.curl.eclipse.util.CurlPluginImages;

/**
 * Factory for a singleton Curl Console, as well as manager for a singleton Curl console data proxy. 
 * Once the agent is created, any console text is sent to the proxy until this proxy and
 * its agent are removed.
 */
public class CurlConsoleFactory implements IConsoleFactory
{
    private final IConsoleManager fConsoleManager;
    private MessageConsole fConsole;
    private MessageConsoleStream fConsoleStream;
    private ConsoleProxyData fConsoleProxy;

    public CurlConsoleFactory()
    {
        fConsoleManager = ConsolePlugin.getDefault().getConsoleManager();
        fConsoleManager.addConsoleListener(new IConsoleListener() {
            public void consolesAdded(
                    IConsole[] consoles)
            {
            }

            public void consolesRemoved(
                    IConsole[] consoles)
            {
                for (IConsole element : consoles) {
                    if (element == fConsole) {
                        fConsoleProxy.removeConsole();
                        try {
                            fConsoleStream.close();
                        } catch (Exception e) {
                            CoreUtil.logError("Print to console failed", e); //$NON-NLS-1$
                        }
                        fConsole = null;
                        fConsoleStream = null;
                        fConsoleProxy = null;
                    }
                }
            }
        });
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.ui.console.IConsoleFactory#openConsole()
     */
    public void openConsole()
    {
        if (fConsole == null) {
            fConsole = new MessageConsole(
                    ConsoleMessages.CurlConsoleName, 
                    CoreUtil.createImageDescriptor(
                            CurlPlugin.getDefault().getBundle(),
                            CurlPluginImages.ICONS_PATH.append("project-curl-file.gif"), //$NON-NLS-1$
                            true));
            fConsoleStream = fConsole.newMessageStream();
            fConsoleManager.addConsoles(new IConsole[] { fConsole });
            fConsoleProxy = new ConsoleProxyData(this);
            fConsoleProxy.openConsole();
        }
        fConsoleManager.showConsoleView(fConsole);
    }

    public void writeToConsoleResponse(
            String text)
    {
        // Just in case there is a late write coming...maybe we don't need it... TODO:
        if (fConsoleStream == null)
            return;
        
        try {
            fConsoleStream.print(text);
            fConsoleStream.flush();
        } catch (Exception e) {
            CoreUtil.logError("Print to console failed", e); //$NON-NLS-1$
        }
    }
}
