/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.changeapi;

import java.net.URL;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.changeapi.ProjectChangeAPIVersionDialog.VersionSelected;
import com.curl.eclipse.remote.WorkbenchProxy.ProjectVersionInfo;
import com.curl.eclipse.util.CoreUtil;
import com.curl.eclipse.util.CurlProject;

/**
 * TODO: this classname no longer reflect the ActionDelegate super classname.
 * 
 * @author fmisiak
 *
 */
public class ProjectChangeAPIVersionProjectHandler extends ActionDelegate
    implements IWorkbenchWindowActionDelegate
{
    
    private IWorkbenchWindow fWindow;

    public ProjectChangeAPIVersionProjectHandler()
    {
    }
    
    public void init(
            IWorkbenchWindow window)
    {
        fWindow = window;
    }
    
    @Override
    public void selectionChanged(
            IAction action,
            ISelection selection)
    {
        CurlProject curlProject = CoreUtil.getCurlProject(selection);
        action.setEnabled(curlProject != null);
    }
    
    @Override
    public void run(
            IAction action)
    {
        IWorkbenchPart part = fWindow.getActivePage().getActivePart();
        final IProject project = CoreUtil.getProject(part);
        final URL curlProjectURL = CoreUtil.getCurlProjectURL(project, true);
        if (curlProjectURL == null) {
            CoreUtil.logWarning("Cannot locate project.cprj file for project=" + project.getLocationURI()); //$NON-NLS-1$
            return ;
        }
        ProjectVersionInfo info = CurlPlugin.getDefault().getWorkbenchProxy().queryProjectVersionInfo(
                curlProjectURL);
        final VersionSelected versionChosen = new VersionSelected();
        ProjectChangeAPIVersionDialog dialog = new ProjectChangeAPIVersionDialog(
                fWindow.getShell(),
                project,
                info,
                versionChosen);

        if (dialog.open() == Window.OK) {

            if (!info.getCurrentVersion().equals(versionChosen.newAPIVersion)) {
                CurlPlugin.getDefault().getWorkbenchProxy().updateProjectVersionInfo(
                        curlProjectURL,
                        versionChosen.newAPIVersion);
            }
            updateHeraldsIfRequired(fWindow, project, versionChosen);
        }
    }
    
    private void updateHeraldsIfRequired(
            final IWorkbenchWindow window,
            IProject project,
            final VersionSelected versionChosen)
    {
        if (!versionChosen.updateHeralds) {
            return;
        }
        FileTextSearchScope newSearchScope = FileTextSearchScope.newSearchScope(
                new IResource[] { project },
                new String[] { "*.curl", "*.scurl", "*.xcurl", "*.dcurl", "*.mcurl" }, //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
                false);
        String regExp = "(\\{\\s*curl\\s+)((?s:.)*?)(\\s+(?:applet|script|manifest|package)\\s*\\})"; //$NON-NLS-1$
        final FileSearchQuery fileSearchQuery = new FileSearchQuery(regExp, true, true, newSearchScope);
        IQueryListener queryListener = new IQueryListener() {

            public void queryAdded(
                    ISearchQuery query)
            {
            }

            public void queryFinished(
                    ISearchQuery query)
            {
                if (query == fileSearchQuery) {
                    NewSearchUI.removeQueryListener(this);
                    window.getShell().getDisplay().asyncExec(new Runnable() {
                        public void run()
                        {
                            ISearchResultViewPart view = NewSearchUI.activateSearchResultView();
                            if (view != null) {
                                ISearchResultPage page = view.getActivePage();
                                if (page instanceof FileSearchPage) {
                                    FileSearchPage filePage = (FileSearchPage)page;
                                    Object[] elements = filePage.getInput().getElements();
                                    IFile[] files = new IFile[elements.length];
                                    System.arraycopy(elements, 0, files, 0, files.length);
                                    String replaceWithExpr = "$1" + versionChosen.newVersionForHeralds //$NON-NLS-1$
                                    + "$3"; //$NON-NLS-1$

                                    try {
                                        new UnsafeAction().doit(replaceWithExpr, filePage, files);
                                    } catch (Throwable e) {
                                        CoreUtil.logInfo(
                                                "Replace Herald feature not available with this version of Eclipse"); //$NON-NLS-1$
                                        ManualStepDialog dialog = new  ManualStepDialog(fWindow.getShell(), replaceWithExpr);
                                        dialog.open();
                                    }
                                }
                            }
                        }
                    });

                }
            }

            public void queryRemoved(
                    ISearchQuery query)
            {
            }

            public void queryStarting(
                    ISearchQuery query)
            {
            }
        };
        NewSearchUI.addQueryListener(queryListener);
        NewSearchUI.runQueryInBackground(fileSearchQuery);
    }
        
    /**
     * Unsafe only because it uses eclipse internal APIs. If a class cannot be resolved on a newer version of
     * eclipse (post 3.3.1.1) then the action will obviously fail because this class cannot be resolved by
     * Eclipse class-loader. But at least this will not prevent the Curl plug-in from loading.
     * Note that this class will be loaded lazily by the class loader.
     */
    private static class UnsafeAction
    {
        void doit(String replaceWithExpr, FileSearchPage filePage, IFile[] files)
        {
            new ReplaceAction2(replaceWithExpr, filePage, files).run();
        }
    }
}
