/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.changeapi;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.curl.eclipse.remote.WorkbenchProxy.ProjectVersionInfo;
import com.curl.eclipse.util.Messages;

public class ProjectChangeAPIVersionDialog extends MessageDialog
{

    static class VersionSelected
    {
        String newAPIVersion;
        boolean updateHeralds;
        String newVersionForHeralds;
    }
    

    private final ProjectVersionInfo fVersionInfo;
    private Combo fNewAPIVersionCombo;
    private final VersionSelected fVersionSelected;
    private Button fUpdateheraldsCheckBox;
    private Text fVersionForHeraldText;

    public ProjectChangeAPIVersionDialog(
            Shell parentShell, 
            IProject project,
            ProjectVersionInfo versionInfo, 
            VersionSelected versionSelected)
    {
        super(parentShell, ChangeApiMessages.ChangeAPIVersionDialog_title, null,
                Messages.format(
                        ChangeApiMessages.ChangeAPIVersionDialog_message, 
                        project.getName()), 
                NONE,// INFORMATION, 
                new String[] { 
                    IDialogConstants.OK_LABEL,
                    IDialogConstants.CANCEL_LABEL }, 0);
        setShellStyle(SWT.RESIZE | getShellStyle());
        fVersionInfo = versionInfo;
        fVersionSelected = versionSelected;
     
    }

    @Override
    protected void buttonPressed(int buttonId)
    {
        fVersionSelected.newAPIVersion = fNewAPIVersionCombo.getItem(fNewAPIVersionCombo.getSelectionIndex());
        fVersionSelected.updateHeralds = fUpdateheraldsCheckBox.getSelection();
        fVersionSelected.newVersionForHeralds = fVersionForHeraldText.getText();
        super.buttonPressed(buttonId);
    }
    
    @Override
    protected Control createCustomArea(Composite parent) 
    {
        Composite area = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.marginWidth = layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        area.setLayout(layout);
        area.setLayoutData(new GridData(GridData.FILL_BOTH));
        
        Label label1 = new Label(area, SWT.NONE);
        label1.setText(ChangeApiMessages.ChangeAPIVersionDialog_current_api_version);
        Label label2 = new Label(area, SWT.NONE);
        label2.setText(fVersionInfo.getCurrentVersion());
        
        Label label3 = new Label(area, SWT.NONE);
        label3.setText(ChangeApiMessages.ChangeAPIVersionDialog_new_api_version);
        fNewAPIVersionCombo = new Combo(area, SWT.DROP_DOWN | SWT.READ_ONLY);
        String[] array = fVersionInfo.getAvailableVersions().toArray(
                new String[fVersionInfo.getAvailableVersions().size()]);
        fNewAPIVersionCombo.setItems(array);
        for (int i = 0; i < array.length; i++) {
            if (array[i].equals(fVersionInfo.getCurlVersionNumber2())) {
                fNewAPIVersionCombo.select(i);
                break;
            }
        }

        /*
         * Provide checkbox and textfield to offer a way to replace heralds
         */
        Group heraldGroup = new Group(area, SWT.NONE);
        heraldGroup.setText(ChangeApiMessages.ChangeAPIVersionDialog_herald_group);
        GridData horizontalSpan1 = new GridData(GridData.FILL_HORIZONTAL);
        horizontalSpan1.horizontalSpan = 2;
        heraldGroup.setLayoutData(horizontalSpan1);
        heraldGroup.setLayout(new FormLayout());

        fUpdateheraldsCheckBox = new Button(heraldGroup, SWT.CHECK);
        fUpdateheraldsCheckBox.setText(ChangeApiMessages.ChangeAPIVersionDialog_change_herald_in_project);
        FormData checkBoxFormData = new FormData();
        checkBoxFormData.left = new FormAttachment(0, 5);
        checkBoxFormData.right = new FormAttachment(100, -5);
        fUpdateheraldsCheckBox.setLayoutData(checkBoxFormData);
        fUpdateheraldsCheckBox.addListener(SWT.Selection, new Listener() {
            public void handleEvent(
                    Event event)
            {
                if (fUpdateheraldsCheckBox.getSelection()) {
                    fVersionForHeraldText.setText(fNewAPIVersionCombo.getItem(fNewAPIVersionCombo.getSelectionIndex()));
                }
                updateEnablement();
            }
        });

        Label label4 = new Label(heraldGroup, SWT.NONE);
        label4.setText(ChangeApiMessages.ChangeAPIVersionDialog_new_herald_version);
        FormData label4FormData = new FormData();
        label4FormData.left = new FormAttachment(10, 5);
        label4FormData.right = new FormAttachment(50, -5);
        label4FormData.top = new FormAttachment(fUpdateheraldsCheckBox, 5);
        label4.setLayoutData(label4FormData);

        fVersionForHeraldText = new Text(heraldGroup, SWT.BORDER | SWT.SINGLE);
        fVersionForHeraldText.setText(fVersionInfo.getCurrentVersion()); // should default to new API version?!
        FormData textFormData = new FormData();
        textFormData.left = new FormAttachment(label4, 5);
        textFormData.top = new FormAttachment(fUpdateheraldsCheckBox, 5);
        textFormData.width = 120;
        fVersionForHeraldText.setLayoutData(textFormData);
        return area;
    }
    
    @Override
    protected void createDialogAndButtonArea(
            Composite parent)
    {
        super.createDialogAndButtonArea(parent);
        updateEnablement();
    }
    /**
     * Updates the enablement of the dialog's ok button based
     * on the current choices in the dialog.
     */
    private void updateEnablement() {
        boolean enabled = (! fNewAPIVersionCombo.getItem(fNewAPIVersionCombo.getSelectionIndex()).equals(fVersionInfo.getCurrentVersion()))
            || fUpdateheraldsCheckBox.getSelection();
        getButton(OK).setEnabled(enabled);
        fVersionForHeraldText.setEnabled(fUpdateheraldsCheckBox.getSelection());
    }
    
}
