/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
/**
 * 
 */
package com.curl.eclipse.changeapi;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/**
 * This dialog is used when the Eclipse "search" plug-in 
 * available at runtime does not offer the expected internal APIs
 * to conduct an automated Herald Replace.
 * One of the goal is to display a regular expression,
 * and make it selectable.
 */
class ManualStepDialog extends MessageDialog
{
    private final String fReplaceWithExpr;
    
    // Max value width in characters before wrapping
    private static final int MAX_VALUE_WIDTH = 30;

    ManualStepDialog(Shell shell, String replaceWithExpr)
    {
        super(shell, ChangeApiMessages.ChangeAPIVersionDialog_title, null,
                ChangeApiMessages.ChangeAPIVersionDialog_manual_replace, 
                INFORMATION, 
                new String[] {IDialogConstants.CLOSE_LABEL}, 0);
        setShellStyle(SWT.RESIZE | getShellStyle());
        fReplaceWithExpr = replaceWithExpr;
    }
    
    @Override
    protected Control createCustomArea(Composite parent) 
    {
        Composite area = new Composite(parent, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.marginWidth = layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        area.setLayout(layout);
        area.setLayoutData(new GridData(GridData.FILL_BOTH));
        
        Label label1 = new Label(area, SWT.NONE);
        label1.setText(ChangeApiMessages.ChangeAPIVersionDialog_value);

        Text locationValue = new Text(area, SWT.BORDER | SWT.WRAP
                | SWT.READ_ONLY);
        locationValue.setText(fReplaceWithExpr);
        GridData gd = new GridData();
        gd.widthHint = convertWidthInCharsToPixels(MAX_VALUE_WIDTH);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = GridData.FILL;
        locationValue.setLayoutData(gd);
        locationValue.setFont(parent.getFont());
        locationValue.setBackground(locationValue.getDisplay().getSystemColor(
                SWT.COLOR_WIDGET_BACKGROUND));

        return area;
    }
}