/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package com.curl.eclipse.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.navigator.ICommonMenuConstants;

/**
 * Action group that adds the actions opening a new editor to the 
 * context menu and the action bar's navigate menu.
 *
 * <p>
 * This class may be instantiated; it is not intended to be subclassed.
 * </p>
 * 
 * see org.eclipse.jdt.ui.actions.OpenEditorActionGroup
 */
public class OpenEditorActionGroup extends ActionGroup {

	private final IWorkbenchSite fSite;
	private boolean fIsEditorOwner;
	private final OpenAction fOpen;

	/**
	 * Creates a new <code>OpenActionGroup</code>. The group requires
	 * that the selection provided by the part's selection provider is of type <code>
	 * org.eclipse.jface.viewers.IStructuredSelection</code>.
	 * 
	 * @param part the view part that owns this action group
	 */
	public OpenEditorActionGroup(IViewPart part) {
		fSite= part.getSite();
		fOpen= new OpenAction(fSite);
		initialize(fSite.getSelectionProvider());
	}
	
//	/**
//	 * Note: This constructor is for internal use only. Clients should not call this constructor.
//	 * @param editor the Java editor
//	 */
//	public OpenEditorActionGroup(CurlEditor editor) {
//		fIsEditorOwner= true;
//		fOpen= new OpenAction(editor);
//		fOpen.setActionDefinitionId(ICurlEditorActionDefinitionIds.OPEN_EDITOR);
//		editor.setAction("OpenEditor", fOpen); //$NON-NLS-1$
//		fSite= editor.getEditorSite();
//		initialize(fSite.getSelectionProvider());
//	}

	/**
	 * Returns the open action managed by this action group. 
	 * 
	 * @return the open action. Returns <code>null</code> if the group
	 * 	doesn't provide any open action
	 */
	public IAction getOpenAction() {
		return fOpen;
	}

	private void initialize(ISelectionProvider provider) {
		ISelection selection= provider.getSelection();
		fOpen.update(selection);
		if (!fIsEditorOwner) {
			provider.addSelectionChangedListener(fOpen);
		}
	}

	/* (non-Javadoc)
	 * Method declared in ActionGroup
	 */
	@Override
    public void fillActionBars(IActionBars actionBar) {
		super.fillActionBars(actionBar);
		setGlobalActionHandlers(actionBar);
	}
	
	/* (non-Javadoc)
	 * Method declared in ActionGroup
	 */
	@Override
    public void fillContextMenu(IMenuManager menu) {
		super.fillContextMenu(menu);
		appendToGroup(menu, fOpen);
		if (!fIsEditorOwner) {
			addOpenWithMenu(menu);
		}
	}

	/*
	 * @see ActionGroup#dispose()
	 */
	@Override
    public void dispose() {
		ISelectionProvider provider= fSite.getSelectionProvider();
		provider.removeSelectionChangedListener(fOpen);
		super.dispose();
	}
	
	private void setGlobalActionHandlers(IActionBars actionBars) {
		actionBars.setGlobalActionHandler(CurlActionConstants.OPEN, fOpen);
	}
	
	private void appendToGroup(IMenuManager menu, IAction action) {
		if (action.isEnabled())
			menu.appendToGroup(ICommonMenuConstants.GROUP_OPEN, action);
	}
	
	private void addOpenWithMenu(IMenuManager menu) {
		ISelection selection= getContext().getSelection();
		if (selection.isEmpty() || !(selection instanceof IStructuredSelection))
			return;
		IStructuredSelection ss= (IStructuredSelection)selection;
		if (ss.size() != 1)
			return;

		Object o= ss.getFirstElement();
		if (! (o instanceof IFile)) {
            return;
		}
	    IFile file = (IFile)o;
//		if (!(o instanceof CurlElement))
//			return;

//		CurlElement element= (CurlElement)o;
//		if (element.getType() != null)
//		    return;
//		IFile file = element.getFile();
		
		// Create a menu.
		IMenuManager submenu= new MenuManager(ActionMessages.OpenWithMenu_label); 
		submenu.add(new OpenWithMenu(fSite.getPage(), file));

		// Add the submenu.
		menu.appendToGroup(ICommonMenuConstants.GROUP_OPEN, submenu);
	}
}
