/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.actions;

import java.util.Iterator;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import com.curl.eclipse.core.CurlElement;
import com.curl.eclipse.editors.CurlEditor;
import com.curl.eclipse.util.CurlUIIDs;
import com.curl.eclipse.util.Messages;

/**
 * This action opens a Curl editor on a Curl element or file.
 * 
 * see org.eclipse.jdt.ui.actions.OpenAction
 */
public class OpenAction extends SelectionDispatchAction {
	
//	private CurlEditor fEditor;
    private final EditorOpener editorOpener = new EditorOpener();
	
	/**
	 * Creates a new <code>OpenAction</code>. The action requires
	 * that the selection provided by the site's selection provider is of type <code>
	 * org.eclipse.jface.viewers.IStructuredSelection</code>.
	 * 
	 * @param site the site providing context information for this action
	 */
	public OpenAction(IWorkbenchSite site) {
		super(site);
		setText(ActionMessages.OpenAction_label); 
		setToolTipText(ActionMessages.OpenAction_tooltip); 
		setDescription(ActionMessages.OpenAction_description); 
		PlatformUI.getWorkbench().getHelpSystem().setHelp(this, CurlUIIDs.OPEN_ACTION);
	}
	
//	/**
//	 * Note: This constructor is for internal use only. Clients should not call this constructor.
//	 * @param editor the Java editor
//	 */
//	public OpenAction(CurlEditor editor) {
//		this(editor.getEditorSite());
//		fEditor= editor;
//		setText(ActionMessages.OpenAction_declaration_label); 
//		setEnabled(EditorUtility.getEditorInputJavaElement(fEditor, false) != null);
//	}
	
	/* (non-Javadoc)
	 * Method declared on SelectionDispatchAction.
	 */
	@Override
    public void selectionChanged(ITextSelection selection) {
	}

	/* (non-Javadoc)
	 * @see com.curl.eclipse.actions.SelectionDispatchAction#selectionChanged(org.eclipse.jface.viewers.IStructuredSelection)
	 */
	@Override
	public void selectionChanged(IStructuredSelection selection) {
		setEnabled(checkEnabled(selection));
	}
	
	@SuppressWarnings("unchecked")
    private boolean checkEnabled(IStructuredSelection selection) {
		if (selection.isEmpty())
			return false;
		for (Iterator iter= selection.iterator(); iter.hasNext();) {
			Object element= iter.next();
//			if (element instanceof ISourceReference)
//				continue;
			if (element instanceof CurlElement) {
                continue;
            }
			if (element instanceof IFile) {
				continue;
			}
			if (element instanceof IFileStore) {
			    continue;
			}
//			if (JavaModelUtil.isOpenableStorage(element))
//				continue;
			return false;
		}
		return true;
	}
	
	/* (non-Javadoc)
	 * Method declared on SelectionDispatchAction.
	 */
//	public void run(ITextSelection selection) {
//		if (!isProcessable())
//			return;
//		try {
//			IJavaElement[] elements= SelectionConverter.codeResolveForked(fEditor, false);
//			if (elements == null || elements.length == 0) {
//				IEditorStatusLine statusLine= (IEditorStatusLine) fEditor.getAdapter(IEditorStatusLine.class);
//				if (statusLine != null)
//					statusLine.setMessage(true, ActionMessages.OpenAction_error_messageBadSelection, null); 
//				getShell().getDisplay().beep();
//				return;
//			}
//			IJavaElement element= elements[0];
//			if (elements.length > 1) {
//				element= SelectionConverter.selectJavaElement(elements, getShell(), getDialogTitle(), ActionMessages.OpenAction_select_element);
//				if (element == null)
//					return;
//			}
//
//			int type= element.getElementType();
//			if (type == IJavaElement.JAVA_PROJECT || type == IJavaElement.PACKAGE_FRAGMENT_ROOT || type == IJavaElement.PACKAGE_FRAGMENT)
//				element= EditorUtility.getEditorInputJavaElement(fEditor, false);
//			run(new Object[] {element} );
//		} catch (InvocationTargetException e) {
//			ExceptionHandler.handle(e, getShell(), getDialogTitle(), ActionMessages.OpenAction_error_message); 
//		} catch (InterruptedException e) {
//			// ignore
//		}
//	}

//	private boolean isProcessable() {
//		if (fEditor != null) {
//			IJavaElement je= EditorUtility.getEditorInputJavaElement(fEditor, false);
//			if (je instanceof ICompilationUnit && !JavaModelUtil.isPrimary((ICompilationUnit)je))
//				return true; // can process non-primary working copies
//		}
//		return ActionUtil.isProcessable(fEditor);
//	}
	
	/* (non-Javadoc)
	 * Method declared on SelectionDispatchAction.
	 */
	@Override
    public void run(IStructuredSelection selection) {
		if (!checkEnabled(selection))
			return;
		run(selection.toArray());
	}
	
	/**
	 * Note: this method is for internal use only. Clients should not call this method.
	 * 
	 * @param elements the elements to process
	 */
	private void run(Object[] elements) {
		if (elements == null)
			return;
		
		MultiStatus status= new MultiStatus(CurlUIIDs.ID_PLUGIN, IStatus.OK, ActionMessages.OpenAction_multistatus_message, null);
//		status.add(new Status(IStatus.ERROR, CurlUIIDs.ID_PLUGIN, IStatus.ERROR, "TO BE IMPLEMENTED", null));
		
		for (Object element : elements) {
			try {
				if (element instanceof IFile) {
                    openEditor((IFile)element);
                }
	            if (element instanceof IFileStore) {
	                openEditor((IFileStore) element);
	                continue;
	            }
                if (element instanceof CurlElement) {
                    CurlElement curlElem = (CurlElement)element;
                    IEditorPart editor = openEditor(curlElem.getFile());
                    if (editor instanceof CurlEditor) {
                        CurlEditor curlEditor = (CurlEditor)editor;
                        curlEditor.selectAndReveal(curlElem);
                    }
//                    if (editor instanceof ITextEditor) {
//                        ((ITextEditor)editor).selectAndReveal(
//                                curlElem.getOffset(),
//                                curlElem.getSymbolName().length());
//                        return;
//                    }
                }
		      
//				boolean activateOnOpen= fEditor != null ? true : OpenStrategy.activateOnOpen();
//				IEditorPart part= EditorUtility.openInEditor(element, activateOnOpen);
//				if (part != null && element instanceof IJavaElement)
//					JavaUI.revealInEditor(part, (IJavaElement)element);
			} catch (PartInitException e) {
				String message= Messages.format(ActionMessages.OpenAction_error_problem_opening_editor, element, e.getStatus().getMessage());
				status.add(new Status(IStatus.ERROR, CurlUIIDs.ID_PLUGIN, IStatus.ERROR, message, null));
//			} catch (CoreException e) {
//				String message= Messages.format(ActionMessages.OpenAction_error_problem_opening_editor, element, e.getStatus().getMessage());
//				status.add(new Status(IStatus.ERROR, CurlUIIDs.ID_PLUGIN, IStatus.ERROR, message, null));
//				CoreUtil.logError("opening " + element.toString(), e);
			}
		}
		if (!status.isOK()) {
			IStatus[] children= status.getChildren();
			ErrorDialog.openError(getShell(), getDialogTitle(), ActionMessages.OpenAction_error_message, children.length == 1 ? children[0] : status);
		}
	}

    private void openEditor(
            IFileStore element)
    {
        editorOpener.open(element, OpenStrategy.activateOnOpen(), OpenStrategy.activateOnOpen());
    }

    private IEditorPart openEditor(
            IFile file) throws PartInitException
    {
        IEditorPart editor = editorOpener.open(file, OpenStrategy.activateOnOpen(), false);
        return editor;
    }
	
	private String getDialogTitle() {
		return ActionMessages.OpenAction_error_title; 
	}
}
