/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.remote.WorkbenchWindowProxy;

public class GenericWorkbenchWindowAction extends ActionDelegate
    implements IWorkbenchWindowActionDelegate
{

    private IAction fAction;
    private IWorkbenchWindow fWindow;
    private WorkbenchWindowProxy fWindowProxy;

    @Override
    public void init(
            IAction action)
    {
        super.init(action);
        fAction = action;
        registerActionIfPossible();
    }

    public void init(
            IWorkbenchWindow window)
    {
        fWindow = window;
        registerActionIfPossible();
    }

    private void registerActionIfPossible()
    {
        if (fWindowProxy != null) {
            return;
        }
        if (fWindow == null || fAction == null) {
            return;
        }
        fWindowProxy = CurlPlugin.getDefault().getWorkbenchOperations().getWorkbenchWindowProxyFor(fWindow);
        fWindowProxy.registerAction(fAction);
    }
    
    
    @Override
    public void run(
            IAction action)
    {
        fWindowProxy.doOperation(action);
    }

}
