/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.actions;


import java.util.List;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.util.CurlPluginImages;
import com.curl.eclipse.util.WorkbenchOperations;
import com.curl.eclipse.util.WorkbenchOperations.MenuDescriptor;

/**
 * 
 */
public class CustomEditorsAction implements IWorkbenchWindowPulldownDelegate2, IWorkbenchWindowActionDelegate
{
    private Menu fMenu;
    
    public void init(
            IWorkbenchWindow window)
    {
    }

    public void selectionChanged(
            IAction action,
            ISelection selection)
    {
        // do nothing
    }

    public Menu getMenu(
            Menu parent)
    {
        setMenu(new Menu(parent));
        return fMenu;
    }

    public Menu getMenu(
            Control parent)
    {
        setMenu(new Menu(parent));
        return fMenu;
    }

    public void dispose()
    {
        setMenu(null);
    }

    public void run(
            IAction action)
    {
        // TODO: Is there a way to not implement this method, since it does
        // nothing?
        // I tried. But the menu item is not included unless I implement
        // IWorkbenchWindowActionDelegate
    }

    private void setMenu(
            Menu menu)
    {
        if (fMenu != null)
            fMenu.dispose();
        fMenu = menu;
        if (fMenu != null) {
            fMenu.addMenuListener(new MenuListener() {
                @Override
                public void menuHidden(
                        MenuEvent e)
                {
                    // do nothing
                }

                @Override
                public void menuShown(
                        MenuEvent e)
                {
                    fillMenu();
               }
            });
        }
    }

    private void fillMenu()
    {
        final WorkbenchOperations workbenchOperations = CurlPlugin.getDefault().getWorkbenchOperations();
        disposeMenuItems(); 
        List<MenuDescriptor> toolMenuDescriptors = workbenchOperations.getToolMenuDescriptors();
        for (final MenuDescriptor menuDescriptor : toolMenuDescriptors) {
            ActionContributionItem item = new ActionContributionItem(
                    new Action(menuDescriptor.fName, CurlPluginImages.DESC_OBJS_CUSTOM_EDITOR) {
                        @Override
                        public void run()
                        {
                            workbenchOperations.launchTool(menuDescriptor.fId);
                        }
                    });
            item.fill(fMenu, -1);
        }
    }

    private void disposeMenuItems()
    {
        if (fMenu == null || fMenu.isDisposed()) {
            return;
        }
        MenuItem[] items = fMenu.getItems();
        for (MenuItem menuItem : items) {
            if (!menuItem.isDisposed()) {
                menuItem.dispose();
            }
        }
    }
}
