/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.actions;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

import com.curl.eclipse.util.CoreUtil;
import com.curl.eclipse.util.CurlUIIDs;

public class CurlProjectFileEditorInputPropertyTester extends PropertyTester
{

    @Override
    public boolean test(
            Object receiver,
            String property,
            Object[] args,
            Object expectedValue)
    {
        if (! (receiver instanceof IEditorPart)) {
            return false;
        }
        IEditorPart editorPart = (IEditorPart) receiver;
        IEditorInput editorInput = editorPart.getEditorInput();
        if (false == editorInput instanceof IFileEditorInput) {
            return false;
        }
        IProject eclipseProject = ((IFileEditorInput) editorInput).getFile().getProject();
        try {
            return eclipseProject.hasNature(CurlUIIDs.ID_CURL_NATURE);
        } catch (CoreException e) {
            CoreUtil.logError("While testing project=" + eclipseProject.getLocationURI(), e); //$NON-NLS-1$
            return false;
        }
    }

}
