/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import com.curl.eclipse.CurlPlugin;
import com.curl.eclipse.debug.AddBreakpointExceptionDialog;
import com.curl.eclipse.debug.CurlExceptionBreakpointDescriptor;
import com.curl.eclipse.debug.ManageBreakpoints;

/**
 * The workbench menu action for adding an exception breakpoint
 */
public class AddExceptionBreakpointAction implements IViewActionDelegate, IWorkbenchWindowActionDelegate
{
    private IWorkbenchWindow fWorkbenchWindow = null;

    public void run(
            IAction action)
    {
        AddBreakpointExceptionDialog dialog = new AddBreakpointExceptionDialog(fWorkbenchWindow.getShell());
        if (dialog.open() == Window.OK) {
            ManageBreakpoints manageBreakpoints = CurlPlugin.getDefault().getManageBreakpoints();
            manageBreakpoints.registerExceptionBreakpoint(
                    new CurlExceptionBreakpointDescriptor(
                            true,
                            (String)dialog.getFirstResult()));
        }
    }

    public void init(
            IViewPart view)
    {
    }

    public void selectionChanged(
            IAction action,
            ISelection selection)
    {
    }

    public void dispose()
    {
        fWorkbenchWindow = null;
    }

    public void init(
            IWorkbenchWindow window)
    {
        fWorkbenchWindow = window;
    }
}
