/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse.actions;

import java.util.ResourceBundle;

import org.eclipse.osgi.util.NLS;

public class ActionMessages extends NLS
{
    private static final String BUNDLE_NAME = "com.curl.eclipse.actions.ActionMessages";//$NON-NLS-1$
    private static final String CONSTRUCTED_BUNDLE_NAME = "com.curl.eclipse.actions.constructedactionmessages";//$NON-NLS-1$
    private static ResourceBundle fConstructedBundle = ResourceBundle.getBundle(CONSTRUCTED_BUNDLE_NAME);
    
    public static String OpenAction_label;
    public static String OpenAction_tooltip;
    public static String OpenAction_description;
    public static String OpenAction_multistatus_message;
    public static String OpenAction_error_message;
    public static String OpenAction_error_title;
    public static String OpenWithMenu_label;
    public static String OpenViewActionGroup_showInAction_label;
    public static String OpenAction_error_problem_opening_editor;
    public static String OpenActionInManifestExplorer_label;

    /**
     * Returns the message bundle which contains constructed keys.
     * NOTE:  Used from this package as well as from the com.curl.eclipse.actions package
     * 
     * @return the message bundle
     */
    static ResourceBundle getBundleForConstructedKeys()
    {
        return fConstructedBundle;
    }

    static {
        // load message values from bundle file
        NLS.initializeMessages(BUNDLE_NAME, ActionMessages.class);
    }
    
    private ActionMessages()
    {
        
    }
}
