/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
package com.curl.eclipse;

import java.util.LinkedList;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SafeCompositeManager
{
    private final Shell fInvisibleShell;

    private LinkedList<SafeComposite> pool = new LinkedList<SafeComposite>();

    SafeCompositeManager(
            Display display)
    {
        fInvisibleShell = new Shell(display);
        for (int i = 0; i < 10; i++) {
            pool.addLast(new SafeComposite(fInvisibleShell));
        }
    }

    public SafeComposite allocateSafeSiblingForParent()
    {
        SafeComposite safeComposite = pool.removeFirst();
        pool.addLast(new SafeComposite(fInvisibleShell));
        return safeComposite;
    }

    
    /**
     * FIXME: Hack
     * @return
     */
    public Shell getSafeShell()
    {
        return fInvisibleShell;
    }
}
