/* Copyright (c) 2008 Sumisho Computer Systems Corp. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * Contributors - Curl, Inc. This plugin includes codes from Eclipse code */
/**
 * 
 */
package com.curl.eclipse;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

import com.curl.eclipse.util.CoreUtil;

public class SafeComposite extends Composite
{
    private final Shell fSafeParentShell;
    
    SafeComposite(Shell parentShell)
    {
        super(parentShell, SWT.NONE);
        fSafeParentShell = parentShell;
    }

    public void reparentWithSafe()
    {
        if (isDisposed()) {
            CoreUtil.logWarning("Attempt to reparent a disposed composite"); //$NON-NLS-1$
        }
        setParent(fSafeParentShell);
    }
    
    @Override
    public boolean setFocus()
    {
        // ugly hack to workaround active control tracking issue with Shell
        // see Composite.setFocus(). 
        // This SafeComposite has a Curl component
        // as a child, when Curl has focus then this super.setFocus  would return true
        // without doing anything which would prevent Composite.setFocus to call its super.setFocus
        // which would prevent the Shell to track/activate/deactivate the "active" control correctly.
        // (see related ugly hack for Composite.isVisible() that returns true).
        return false;
    }
    
    @Override
    public boolean isFocusControl()
    {
        return super.isFocusControl();
    }

    public boolean isAttachedToEclipseParent()
    {
        return getParent() != fSafeParentShell;
    }
    
    /**
     * 
     * @param parent is a valid Composite
     */
    public void attachToEclipseParent(
            Composite parent)
    {
        setParent(parent);
        parent.setLayoutData(new GridData(GridData.FILL_BOTH));
        final StackLayout layout = new StackLayout();
        parent.setLayout(layout);
        layout.topControl = this;
        parent.layout();
        
        /*
         * Just before parent gets released we have an opportunity
         * to reparent this SafeComposite
         */
        parent.addDisposeListener(new DisposeListener(){

            @Override
            public void widgetDisposed(
                    DisposeEvent e)
            {
            	if (SafeComposite.this.isDisposed()) {
            		// fmisiak's note: I've seen this only on eclipse shutdown so far.
            		CoreUtil.logWarning("SafeComposite has been disposed to early!"); //$NON-NLS-1$
            		return;
            	}
            	// Reparent this SafeComposite to avoid premature dispose
                reparentWithSafe();
            }});
    }
}